﻿//////////////////////////////////////////////
// PbsProgramTracker.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class Program ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../../Utils/ProgramTracker.h"

#include "PbsMaterialInfo.h"

/// Internals --------------------------------

namespace nkAstraeus
{
	struct PbsProgramIdGenerator
	{
		static unsigned long long generate (const PbsMaterialInfo& info) ;
	} ;

	struct PbsProgramNameGenerator
	{
		constexpr static const char* name = "NILKINS_PBS_PROGRAM_" ;
	} ;
}

/// Class ------------------------------------

namespace nkAstraeus
{
	class PbsProgramTracker final : public ProgramTracker<PbsMaterialInfo, PbsProgramIdGenerator, PbsProgramNameGenerator>
	{
		public :

			// Constructor, destructor
			PbsProgramTracker (nkGraphics::System* graphicsSystem) noexcept ;
			virtual ~PbsProgramTracker () ;
	} ;
}